
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shell.hxx>
#include <TopoDS_Solid.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Lin.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BRepClass3d_SolidExplorer.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <TopoDS_Shell.hxx>
#include <IntCurvesFace_Intersector.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <BRepClass3d.hxx>
#include <BRepClass3d_BndBoxTree.hxx>
#include <BRepClass3d_DataMapIteratorOfMapOfInter.hxx>
#include <BRepClass3d_Intersector3d.hxx>
#include <BRepClass3d_MapOfInter.hxx>
#include <BRepClass3d_SClassifier.hxx>
#include <BRepClass3d_SolidClassifier.hxx>
#include <BRepClass3d_SolidExplorer.hxx>
#include <BRepClass3d_SolidPassiveClassifier.hxx>

// template related includes

#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BRepClass3d_enums(py::module &main_module) {


py::module m = main_module.def_submodule("BRepClass3d", R"#()#");

// user-defined inclusion per module in the body

// enums

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<BRepClass3d , shared_ptr<BRepClass3d>  >(m,"BRepClass3d",R"#(None)#");
    py::class_<BRepClass3d_Intersector3d , shared_ptr<BRepClass3d_Intersector3d>  >(m,"BRepClass3d_Intersector3d",R"#(None)#");
    py::class_<BRepClass3d_SClassifier , shared_ptr<BRepClass3d_SClassifier>  >(m,"BRepClass3d_SClassifier",R"#(Provides an algorithm to classify a point in a solid.)#");
    py::class_<BRepClass3d_SolidExplorer , shared_ptr<BRepClass3d_SolidExplorer>  >(m,"BRepClass3d_SolidExplorer",R"#(Provide an exploration of a BRep Shape for the classification. Provide access to the special UB tree to obtain fast search.)#");
    py::class_<BRepClass3d_SolidPassiveClassifier , shared_ptr<BRepClass3d_SolidPassiveClassifier>  >(m,"BRepClass3d_SolidPassiveClassifier",R"#(None)#");
    preregister_template_NCollection_DataMap<TopoDS_Shape, Standard_Address, TopTools_ShapeMapHasher>(m,"BRepClass3d_MapOfInter");
    py::class_<BRepClass3d_SolidClassifier , shared_ptr<BRepClass3d_SolidClassifier>  , BRepClass3d_SClassifier >(m,"BRepClass3d_SolidClassifier",R"#(Provides an algorithm to classify a point in a solid.)#");

};

// user-defined post-inclusion per module

// user-defined post
