/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef IMAGEVIEWER_H
#define IMAGEVIEWER_H
#include <QScrollArea>
#include <QPrinter>
#include <QLabel>
#include <QSettings>

class QMenu;
class QAction;
class editor;

class imageViewer : public QScrollArea
{
	Q_OBJECT
	/*! thumbnail type */
public:
	enum thumbType
		{
			RXTHUMB, /*!< thumbnail for receiver. */
			TXTHUMB,/*!< thumbnail for transmitter. */
			TEMPLATETHUMB /*!< thumbnail for template. */
		};


public:
	imageViewer(QWidget *parent=0);
  ~imageViewer();
  bool open(QString fileName,bool showMessage=FALSE);
  void open(QImage image);
  bool reload();
  void clear();
  void init();
  bool readThumbSettings(QSettings *qs);
  void writeThumbSettings(QSettings *qs);
  QImage *getImagePtr(int w=0,int h=0);
  QImage *getOriginalImagePtr() {return originalImagePtr;}
  void fitToWindow(bool bfit);
  void setFilename(QString fn);

	void setType(thumbType t);
	QString getFilename() { return fileName;}
  void adaptImage( int w,  int h);
  QRgb * getLineAddress(unsigned int line);
  bool hasValidImage() { return ((imagePtr!=NULL)&&(originalImagePtr!=NULL));}
	void updateImage();
  void save(QString n,QString fmt);
  void enablePopup(bool enable) {popupEnabled=enable;}


private slots:
	void slotZoomIn();
	void slotZoomOut();
	void slotNormalSize();
	void slotFit();
	void slotNew();
	void slotLoad();
	void slotToTX();
	void slotEdit();
	void slotPrint();
	void slotDelete();
  void slotProperties();

signals:
  void layoutChanged();

private:
	void scaleImage(double factor);
	void adjustScrollBar(QScrollBar *scrollBar, double factor);
	QLabel *imageLabel;
	double scaleFactor;
	bool fit;
	void mousePressEvent( QMouseEvent *e );
	QPrinter printer;
	QString fileName; //!< name of the file associated with the thumbnail 
	QString path;
  QImage *imagePtr;
  QImage *originalImagePtr;
	thumbType ttype;
	void loadDialog(); 
	QMenu *popup;
	QAction *newAct;
	QAction *loadAct;
	QAction *toTXAct;
	QAction *editAct;
	QAction *printAct;
	QAction *deleteAct;
	QAction *propertiesAct;
	QAction *zoomInAct;
	QAction *zoomOutAct;
	QAction *fitAct;
	double scaleHint;
	editor *ed;
	void calcDefaultScale();
  void setImage();
  bool popupEnabled;
};

#endif
