VARYING vec2 TexCoord0;
VARYING vec2 TexCoord1;
VARYING vec2 TexCoord2;

const vec3 poisson0 = vec3( 0.000000, 0.000000, 0.000000 );
const vec3 poisson1 = vec3( 0.527837, -0.085868, 0.534776 );
const vec3 poisson2 = vec3( -0.040088, 0.537087, 0.538581 );

void setupPoissonBlurCoords(float inBlurAmount, vec2 inTexInfo )
{
    float incX = inBlurAmount / inTexInfo.x;
    float incY = inBlurAmount / inTexInfo.y;
    TexCoord0 = vec2( INPUT_UV.x + poisson0.x * incX, INPUT_UV.y + poisson0.y * incY );
    TexCoord1 = vec2( INPUT_UV.x + poisson1.x * incX, INPUT_UV.y + poisson1.y * incY );
    TexCoord2 = vec2( INPUT_UV.x + poisson2.x * incX, INPUT_UV.y + poisson2.y * incY );
}

void MAIN()
{
    setupPoissonBlurCoords(blurAmount, OUTPUT_SIZE);
}
