/*
 * AUTOGENERATED - DO NOT EDIT
 *
 * This file is generated from qt-windowmanager.xml by mir_wayland_generator
 */

#include "qt-windowmanager_wrapper.h"

#include <boost/exception/diagnostic_information.hpp>
#include <wayland-server-core.h>

#include "mir/log.h"
#include "mir/wayland/protocol_error.h"
#include "mir/wayland/client.h"

namespace mir
{
namespace wayland
{
extern struct wl_interface const qt_windowmanager_interface_data;
}
}

namespace mw = mir::wayland;

namespace
{
struct wl_interface const* all_null_types [] {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr};
}

// Windowmanager

struct mw::Windowmanager::Thunks
{
    static int const supported_version;

    static void open_url_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t remaining, char const* url)
    {
        try
        {
            auto me = static_cast<Windowmanager*>(wl_resource_get_user_data(resource));
            me->open_url(remaining, url);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "Windowmanager::open_url()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<Windowmanager*>(wl_resource_get_user_data(resource));
    }

    static void bind_thunk(struct wl_client* client, void* data, uint32_t version, uint32_t id)
    {
        auto me = static_cast<Windowmanager::Global*>(data);
        auto resource = wl_resource_create(
            client,
            &qt_windowmanager_interface_data,
            std::min((int)version, Thunks::supported_version),
            id);
        if (resource == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        try
        {
            me->bind(resource);
        }
        catch(...)
        {
            internal_error_processing_request(client, "Windowmanager global bind");
        }
    }

    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

int const mw::Windowmanager::Thunks::supported_version = 1;

mw::Windowmanager::Windowmanager(struct wl_resource* resource, Version<1>)
    : Resource{resource}
{
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::Windowmanager::~Windowmanager()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

void mw::Windowmanager::send_hints_event(int32_t show_is_fullscreen) const
{
    wl_resource_post_event(resource, Opcode::hints, show_is_fullscreen);
}

void mw::Windowmanager::send_quit_event() const
{
    wl_resource_post_event(resource, Opcode::quit);
}

bool mw::Windowmanager::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &qt_windowmanager_interface_data, Thunks::request_vtable);
}

void mw::Windowmanager::destroy_and_delete() const
{
    // Will result in this object being deleted
    wl_resource_destroy(resource);
}

mw::Windowmanager::Global::Global(wl_display* display, Version<1>)
    : wayland::Global{
          wl_global_create(
              display,
              &qt_windowmanager_interface_data,
              Thunks::supported_version,
              this,
              &Thunks::bind_thunk)}
{
}

auto mw::Windowmanager::Global::interface_name() const -> char const*
{
    return Windowmanager::interface_name;
}

struct wl_message const mw::Windowmanager::Thunks::request_messages[] {
    {"open_url", "us", all_null_types}};

struct wl_message const mw::Windowmanager::Thunks::event_messages[] {
    {"hints", "i", all_null_types},
    {"quit", "", all_null_types}};

void const* mw::Windowmanager::Thunks::request_vtable[] {
    (void*)Thunks::open_url_thunk};

mw::Windowmanager* mw::Windowmanager::from(struct wl_resource* resource)
{
    if (resource &&
        wl_resource_instance_of(resource, &qt_windowmanager_interface_data, Windowmanager::Thunks::request_vtable))
    {
        return static_cast<Windowmanager*>(wl_resource_get_user_data(resource));
    }
    else
    {
        return nullptr;
    }
}

namespace mir
{
namespace wayland
{

struct wl_interface const qt_windowmanager_interface_data {
    mw::Windowmanager::interface_name,
    mw::Windowmanager::Thunks::supported_version,
    1, mw::Windowmanager::Thunks::request_messages,
    2, mw::Windowmanager::Thunks::event_messages};

}
}
