% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bit.R, R/generics.R
\name{as.bit.NULL}
\alias{as.bit.NULL}
\alias{as.bit.bit}
\alias{as.bit.logical}
\alias{as.bit.integer}
\alias{as.bit.double}
\alias{as.bit.bitwhich}
\alias{as.bit.which}
\alias{as.bit.ri}
\alias{as.bit}
\title{Coercing to bit}
\usage{
\method{as.bit}{`NULL`}(x, ...)

\method{as.bit}{bit}(x, ...)

\method{as.bit}{logical}(x, ...)

\method{as.bit}{integer}(x, ...)

\method{as.bit}{double}(x, ...)

\method{as.bit}{bitwhich}(x, ...)

\method{as.bit}{which}(x, length = attr(x, "maxindex"), ...)

\method{as.bit}{ri}(x, ...)

as.bit(x = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{\link{bit}}, \code{\link{logical}},
\code{\link{integer}}, \code{\link{bitwhich}} or an integer from
\code{\link{as.which}} or a boolean \code{\link[ff:vmode]{ff}}}

\item{\dots}{further arguments}

\item{length}{the length of the new bit vector}
}
\value{
\code{is.bit} returns FALSE or TRUE, \code{as.bit} returns a vector
of class 'bit'
}
\description{
Coercing to bit vector
}
\details{
Coercing to bit is quite fast because we use a double loop that fixes each
word in a processor register
}
\section{Methods (by class)}{
\itemize{
\item \code{NULL}: method to coerce to \code{\link{bit}} (zero length) from \code{\link{NULL}}

\item \code{bit}: method to coerce to \code{\link{bit}} from \code{\link{bit}}

\item \code{logical}: method to coerce to \code{\link{bit}} from \code{\link{logical}}

\item \code{integer}: method to coerce to \code{\link{bit}} from
\code{\link{integer}} (\code{0L} and \code{NA} become \code{FALSE},
everthing else becomes \code{TRUE})

\item \code{double}: method to coerce to \code{\link{bit}} from
\code{\link{double}} (\code{0} and \code{NA} become \code{FALSE}, everthing
else becomes \code{TRUE})

\item \code{bitwhich}: method to coerce to \code{\link{bit}} from \code{\link{bitwhich}}

\item \code{which}: method to coerce to \code{\link{bit}} from \code{\link[=as.which]{which}}

\item \code{ri}: method to coerce to \code{\link{bit}} from \code{\link{ri}}
}}

\note{
Zero is coerced to FALSE, all other numbers including NA are coerced
to TRUE.  This differs from the NA-to-FALSE coercion in package ff and may
change in the future.
}
\examples{
as.bit(c(0L,1L,2L,-2L,NA))
as.bit(c(0,1,2,-2,NA))

as.bit(c(FALSE, NA, TRUE))

}
\seealso{
\code{\link{CoercionToStandard}}, \code{\link{as.booltype}}, \code{\link{as.bit}}, \code{\link{as.bitwhich}}
, \code{\link{as.which}}, \code{\link{as.ri}}, \code{\link[ff]{as.hi}},  \code{\link[ff]{as.ff}}
}
\author{
Jens Oehlschlägel
}
\keyword{classes}
\keyword{logic}
