% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/felm_tidiers.R
\name{felm_tidiers}
\alias{felm_tidiers}
\alias{tidy.felm}
\alias{augment.felm}
\alias{glance.felm}
\title{Tidying methods for models with multiple group fixed effects}
\usage{
\method{tidy}{felm}(x, conf.int = FALSE, conf.level = 0.95, fe = FALSE,
  fe.error = fe, ...)

\method{augment}{felm}(x, data = NULL, ...)

\method{glance}{felm}(x, ...)
}
\arguments{
\item{x}{felm object}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level of the interval, used only if
\code{conf.int=TRUE}}

\item{fe}{whether to include estimates of fixed effects}

\item{fe.error}{whether to include standard error of fixed effects}

\item{...}{extra arguments (not used)}

\item{data}{Original data, defaults to extracting it from the model}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy.felm} returns one row for each coefficient. If \code{fe=TRUE}, it also includes rows for for fixed effects estimates. 
There are five columns:
  \item{term}{The term in the linear model being estimated and tested}
  \item{estimate}{The estimated coefficient}
  \item{std.error}{The standard error from the linear model}
  \item{statistic}{t-statistic}
  \item{p.value}{two-sided p-value}

If \code{cont.int=TRUE}, it also includes columns for \code{conf.low} and \code{conf.high}, computed with \code{\link{confint}}.

\code{augment.felm} returns  one row for each observation, with multiple columns added to the original data:
  \item{.fitted}{Fitted values of model}
  \item{.resid}{Residuals}
  If fixed effect are present,  
  \item{.comp}{Connected component}
  \item{.fe_}{Fixed effects (as many columns as factors)}

\code{glance.lm} returns a one-row data.frame with the columns
  \item{r.squared}{The percent of variance explained by the model}
  \item{adj.r.squared}{r.squared adjusted based on the degrees of freedom}
  \item{sigma}{The square root of the estimated residual variance}
  \item{statistic}{F-statistic}
  \item{p.value}{p-value from the F test}
  \item{df}{Degrees of freedom used by the coefficients}
  \item{df.residual}{residual degrees of freedom}
}
\description{
These methods tidy the coefficients of a linear model with multiple group fixed effects
}
\details{
If \code{conf.int=TRUE}, the confidence interval is computed
}
\examples{

if (require("lfe", quietly = TRUE)) {
    N=1e2
    DT <- data.frame(
      id = sample(5, N, TRUE),
      v1 =  sample(5, N, TRUE),                          
      v2 =  sample(1e6, N, TRUE),                        
      v3 =  sample(round(runif(100,max=100),4), N, TRUE),
      v4 =  sample(round(runif(100,max=100),4), N, TRUE) 
    )
    
    result_felm <- felm(v2~v3, DT)
    tidy(result_felm)
    augment(result_felm)
    result_felm <- felm(v2~v3|id+v1, DT)
    tidy(result_felm, fe = TRUE)
    augment(result_felm)
    v1<-DT$v1
    v2 <- DT$v2
    v3 <- DT$v3
    id <- DT$id
    result_felm <- felm(v2~v3|id+v1)
    tidy(result_felm)
    augment(result_felm)
    glance(result_felm)
}
}
