% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/friedman_effsize.R
\name{friedman_effsize}
\alias{friedman_effsize}
\title{Friedman Test Effect Size (Kendall's W Value)}
\usage{
friedman_effsize(
  data,
  formula,
  ci = FALSE,
  conf.level = 0.95,
  ci.type = "perc",
  nboot = 1000,
  ...
)
}
\arguments{
\item{data}{a data.frame containing the variables in the formula.}

\item{formula}{a formula of the form \code{a ~ b | c}, where \code{a}
(numeric) is the dependent variable name; \code{b} is the within-subjects
factor variables; and \code{c} (factor) is the column name containing
individuals/subjects identifier. Should be unique per individual.}

\item{ci}{If TRUE, returns confidence intervals by bootstrap. May be slow.}

\item{conf.level}{The level for the confidence interval.}

\item{ci.type}{The type of confidence interval to use. Can be any of "norm",
"basic", "perc", or "bca". Passed to \code{boot::boot.ci}.}

\item{nboot}{The number of replications to use for bootstrap.}

\item{...}{other arguments passed to the function \code{\link[stats]{friedman.test}()}}
}
\value{
return a data frame with some of the following columns: \itemize{
 \item \code{.y.}: the y variable used in the test. \item \code{n}: Sample
 counts. \item \code{effsize}: estimate of the effect size. \item
 \code{magnitude}: magnitude of effect size. \item \code{conf.low,conf.high}:
 lower and upper bound of the effect size confidence interval.}
}
\description{
Compute the effect size estimate (referred to as \code{w}) for
 Friedman test: \code{W = X2/N(K-1)}; where \code{W} is the Kendall's W
 value; \code{X2} is the Friedman test statistic value; \code{N} is the sample
 size. \code{k} is the number of measurements per subject.

 The Kendall’s W coefficient assumes the value from 0 (indicating no
 relationship) to 1 (indicating a perfect relationship).

 Kendalls uses the Cohen’s interpretation guidelines of \code{0.1 - < 0.3} (small
 effect), \code{0.3 - < 0.5} (moderate effect) and \code{>= 0.5} (large
 effect)

 Confidence intervals are calculated by bootstap.
}
\examples{
# Load data
#:::::::::::::::::::::::::::::::::::::::
data("ToothGrowth")
df <- ToothGrowth \%>\%
    filter(supp == "VC") \%>\%
    mutate(id = rep(1:10, 3))
head(df)

# Friedman test effect size
#:::::::::::::::::::::::::::::::::::::::::
df \%>\% friedman_effsize(len ~ dose | id)
}
\references{
Maciej Tomczak and Ewa Tomczak. The need to report effect size
 estimates revisited. An overview of some recommended measures of effect
 size. Trends in Sport Sciences. 2014; 1(21):19-25.
}
