% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mime_part.R
\name{mime_part_html}
\alias{mime_part_html}
\title{Create an inline HTML MIME Part}
\usage{
mime_part_html(x, ...)
}
\arguments{
\item{x}{Character string, vector/list of character strings
or path to html file.}

\item{...}{Ignored.}
}
\value{
An S3 \code{mime_part} object.
}
\description{
Create a MIME part from a character string containing HTML. If the string matches
a filename the file is read and inserted as an inline character MIME part.
}
\examples{
\dontrun{
sendmail(
  from="from@example.org",
  to="to1@example.org",
  subject="inline HTML",
  msg=mime_part_html("Hello<br>World"),
  control=list(smtpServer="ASPMX.L.GOOGLE.COM")
)

sendmail(
  from="from@example.org",
  to="to1@example.org",
  subject="inline HTML",
  msg=mime_part_html("out/report.html"),
  control=list(smtpServer="ASPMX.L.GOOGLE.COM")
)
}

}
