% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/preprocessing5.R
\name{VST}
\alias{VST}
\alias{VST.default}
\alias{VST.IterableMatrix}
\alias{VST.dgCMatrix}
\alias{VST.matrix}
\title{Variance Stabilizing Transformation}
\usage{
VST(data, margin = 1L, nselect = 2000L, span = 0.3, clip = NULL, ...)

\method{VST}{default}(data, margin = 1L, nselect = 2000L, span = 0.3, clip = NULL, ...)

\method{VST}{IterableMatrix}(
  data,
  margin = 1L,
  nselect = 2000L,
  span = 0.3,
  clip = NULL,
  verbose = TRUE,
  ...
)

\method{VST}{dgCMatrix}(
  data,
  margin = 1L,
  nselect = 2000L,
  span = 0.3,
  clip = NULL,
  verbose = TRUE,
  ...
)

\method{VST}{matrix}(data, margin = 1L, nselect = 2000L, span = 0.3, clip = NULL, ...)
}
\arguments{
\item{data}{A matrix-like object}

\item{margin}{Unused}

\item{nselect}{Number of of features to select}

\item{span}{the parameter \eqn{\alpha} which controls the degree of
    smoothing.}

\item{clip}{Upper bound for values post-standardization; defaults to the
square root of the number of cells}

\item{...}{Arguments passed to other methods}

\item{verbose}{...}
}
\value{
A data frame with the following columns:
\itemize{
 \item \dQuote{\code{mean}}: ...
 \item \dQuote{\code{variance}}: ...
 \item \dQuote{\code{variance.expected}}: ...
 \item \dQuote{\code{variance.standardized}}: ...
 \item \dQuote{\code{variable}}: \code{TRUE} if the feature selected as
  variable, otherwise \code{FALSE}
 \item \dQuote{\code{rank}}: If the feature is selected as variable, then how
  it compares to other variable features with lower ranks as more variable;
  otherwise, \code{NA}
}
}
\description{
Apply variance stabilizing transformation for selection of variable features
}
\keyword{internal}
