% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmpl-glue.R
\name{tmpl_glue}
\alias{tmpl_glue}
\title{glue based template engine}
\usage{
tmpl_glue(
  sep = "",
  open = "{",
  close = "}",
  na = "NA",
  transformer = NULL,
  trim = TRUE
)
}
\arguments{
\item{sep}{Separator used to separate elements.}

\item{open}{The opening delimiter. Doubling the full delimiter escapes
it.}

\item{close}{The closing delimiter. Doubling the full delimiter escapes
it.}

\item{na}{Value to replace NA values with. If \code{NULL} missing values are
propagated, that is an \code{NA} result will cause \code{NA} output.
Otherwise the value is replaced by the value of \code{na}.}

\item{transformer}{A function taking three parameters \code{code}, \code{envir}
and \code{data} used to transform the output of each block before during or
after evaluation.}

\item{trim}{Whether to trim the input template with \code{\link[glue:trim]{glue::trim()}} or not.}
}
\value{
Template function.
}
\description{
Use this template engine to create pages with glue templates.
See \code{\link[glue:glue]{glue::glue()}} for the syntax.
}
\examples{
# See th 'hello' app at
hello_root <- system.file(package = "webfakes", "examples", "hello")
hello_root

app <- new_app()
app$engine("txt", tmpl_glue())
app$use(mw_log())


app$get("/view", function(req, res) {
  txt <- res$render("test")
  res$
    set_type("text/plain")$
    send(txt)
})

# Switch to the app's root: setwd(hello_root)
# Now start the app with: app$listen(3000L)
# Or start it in another process: new_process(app)
}
