---
layout: post
title: Polyglot 1.8.0 - Communitybijdragen release
lang: nl
---

Wordt enthousiast voor Jekyll-Polyglot 1.8.0, dat een aantal functieverbeteringen bevat en documentatie en bijdragen van de community erkent!

## Taalspecifieke permalinks

Een nieuwe functie is om pagina's taalspecifieke permalinks te geven en hun koppeling met andere relatieve pagina's te behouden. Deze nieuwe functie is opnieuw verbeterd door **[antoniovazquezblanco](https://github.com/antoniovazquezblanco)**, een echte gentleman en een geleerde.

## Sitemapgeneratie & meertalige SEO

Deze release erkent ook de kwaliteit [sitemap.xml]({{ site.url }}/sitemap.xml) en [robots.txt]({{ site.url }}/robots.txt) solution provided by **[jerturowetz](https://github.com/jerturowetz)**. Deze website demonstreert en benut nu meer SEO-kracht door deze instellingen te gebruiken om door zoekmachines als een statische Jekyll-website gecrawld te kunnen worden. Zie de voorbeeldwebsitebestanden [hier](https://github.com/untra/polyglot/tree/master/site).

## jekyll :polyglot :post_write hook

Github-gebruiker **[obfusk](https://github.com/obfusk)** heeft een paar [jaar geleden PR](https://github.com/untra/polyglot/pull/142) een heel kleine bijdrage geleverd:

Met polyglot `:site, :post_write` deze functie wordt één keer uitgevoerd voor elk subprocess:

```rb
Jekyll::Hooks.register :site, :post_write do |site|
  ...
end
```

Deze release voegt een custom hook `:post_write` toe die precies één keer wordt uitgevoerd, nadat alle talen zijn verwerkt (of niet `parallel_localization` wordt gebruikt):

```rb
Jekyll::Hooks.register :polyglot, :post_write do |site|
  # Creëer hier iets geweldigs! 
end
```

Deze functie is handig voor complexe statische Jekyll-sites die extra worden gebruikt [jekyll hook plugins](https://jekyllrb.com/docs/plugins/hooks/).

Zij heeft ook een oplossing geleverd voor [extra logboekregistratie bij crashes van taal-subprocessen](https://github.com/untra/polyglot/pull/145). Bedankt voor deze bijdrage!

## Gelokaliseerde variabelen en Portugese vertaling

**[george-gca](https://github.com/george-gca)** is een getalenteerde en geweldige gast, Hij heeft [een hele blogpost bijgedragen](/2024/02/29/localized-variables/) over de beste manier om rich text uit websitegegevens te lokaliseren. Hij heeft ook de [Braziliaans-Portugese sitevertaling](https://polyglot.untra.io/pt-BR/). 

