/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeStampedValue
implements Map.Entry<Long, Object>,
Comparable<TimeStampedValue> {
    private final long m_key;
    private Object m_value;

    public TimeStampedValue(long key, Object value) {
        this.m_key = key;
        this.m_value = value;
    }

    @Override
    public int compareTo(TimeStampedValue obj) {
        int result = this.m_key < obj.m_key ? -1 : (this.m_key == obj.m_key ? 0 : 1);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeStampedValue other = (TimeStampedValue)obj;
        if (this.m_key != other.m_key) {
            return false;
        }
        return !(this.m_value == null ? other.m_value != null : !this.m_value.equals(other.m_value));
    }

    @Override
    public Long getKey() {
        return new Long(this.m_key);
    }

    public long getTime() {
        return this.m_key;
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.m_key ^ this.m_key >>> 32);
        result = 31 * result + (this.m_value == null ? 0 : this.m_value.hashCode());
        return result;
    }

    public boolean isPast() {
        return this.m_key < System.currentTimeMillis();
    }

    @Override
    public Object setValue(Object value) {
        Object ret = this.m_value;
        this.m_value = value;
        return ret;
    }
}

