# Array Metadata

## Main Structure

The array metadata is a folder called `__meta` located here:

```
my_array                            # array folder
   |  ...
   |_ __meta                        # array metadata folder
         |_ <timestamped_name>      # array metadata file
         |_ ...  
         |_ <timestamped_name>.vac  # vacuum file
         |_ ...  
```

`<timestamped_name>` has format `__t1_t2_uuid_v`, where:
* `t1` and `t2` are timestamps in milliseconds elapsed since 1970-01-01 00:00:00 +0000 (UTC)
* `uuid` is a unique identifier
* `v` is the format version

The array metadata folder can contain:
* Any number of [array metadata files](#array-metadata-file)
* Any number of [vacuum files](./vacuum_file.md)

## Array Metadata File 

The array metadata file has the following on-disk format:

| **Field** | **Type** | **Description** |
| :--- | :--- | :--- |
| Key length | `uint32_t` | The length of the key. |
| Key | `uint8_t[]` | The key. |
| Deletion | `char` | `1`/`0` if it is a deletion/insertion. |
| Value type | `char` | The value data type. Present only if `del` is `0`. |
| Number of values | `uint32_t` | The number of values. Present only if `del` is `0`. |
| Value | `uint8_t[]` | The value. Present only if `del` is `0`. |
