/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.input.dis;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mil.navy.nps.dis.BehaviorConsumerIF;
import mil.navy.nps.dis.BehaviorProducerIF;
import mil.navy.nps.dis.DetonationPdu;
import mil.navy.nps.dis.EntityID;
import mil.navy.nps.dis.EntityStatePdu;
import mil.navy.nps.dis.FirePdu;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.math.Quaternion;
import mil.navy.nps.net.BehaviorConsumerThreaded;
import mil.navy.nps.net.BehaviorProducerUDP;
import org.web3d.vrml.nodes.VRMLDISManagerNodeType;
import org.web3d.vrml.nodes.VRMLDISNodeType;
import org.web3d.vrml.renderer.common.input.dis.DISId;
import org.web3d.vrml.renderer.common.input.dis.LinkedList;
import org.web3d.vrml.renderer.common.input.dis.LiveListEntry;
import org.web3d.vrml.renderer.common.input.dis.NodeMapEntry;
import org.web3d.vrml.renderer.common.input.dis.OrderNQuat4dConverger;
import org.web3d.vrml.renderer.common.input.dis.OrderNVector3dConverger;

class DISConnectionHandler
implements BehaviorConsumerIF {
    private static final int DEFAULT_ORDER = 2;
    private static final int DEFAULT_CONVERGENCE_INTERVAL = 200;
    BehaviorConsumerThreaded consumer;
    BehaviorProducerUDP writer;
    DatagramSocket socket;
    InetAddress address;
    Thread readThread;
    private int port;
    private String group;
    int cnt;
    private LinkedList liveList;
    private DISId disId;
    private float[] translation;
    private float[] rotation;
    private float[] dRorientation;
    private Quaternion quaternion = null;
    private Map nodeMap;
    private List managerList;
    private Set notifiedSet;

    public DISConnectionHandler(Map map, LinkedList linkedList, List list, Set set, String string, int n) {
        this.nodeMap = map;
        this.group = string;
        this.port = n;
        this.liveList = linkedList;
        this.managerList = list;
        this.notifiedSet = set;
        this.disId = new DISId(0, 0, 0);
        this.translation = new float[3];
        this.rotation = new float[4];
        this.dRorientation = new float[3];
        this.quaternion = new Quaternion();
        try {
            System.out.println("DIS Listening to port: " + n + " group: " + string);
            this.address = InetAddress.getByName(string);
            try {
                this.socket = new MulticastSocket(n);
                ((MulticastSocket)this.socket).joinGroup(this.address);
            }
            catch (Exception exception) {
                System.out.println("Failed to listen to multicast port.  Trying unicast");
                this.socket.close();
                this.socket = new DatagramSocket(n);
            }
            this.writer = new BehaviorProducerUDP(this.socket);
            this.writer.setUseCopies(false);
            this.writer.setDefaultDestination((Object)this.address, (Object)new Integer(n));
            this.readThread = new Thread((Runnable)this.writer);
            this.readThread.start();
            this.writer.addListener((BehaviorConsumerIF)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BehaviorProducerUDP getWriter() {
        return this.writer;
    }

    public void receivePdu(ProtocolDataUnit protocolDataUnit, BehaviorProducerIF behaviorProducerIF) {
        ++this.cnt;
        if (this.cnt % 100 == 0) {
            // empty if block
        }
        int n = protocolDataUnit.getPduTypeValue();
        switch (n) {
            case 2: 
            case 143: {
                FirePdu firePdu = (FirePdu)protocolDataUnit;
                EntityID entityID = firePdu.getTargetEntityID();
                this.disId.setValue(entityID.getSiteIDValue(), entityID.getApplicationIDValue(), entityID.getEntityIDValue());
                NodeMapEntry nodeMapEntry = (NodeMapEntry)this.nodeMap.get(this.disId);
                if (nodeMapEntry == null) {
                    return;
                }
                VRMLDISNodeType vRMLDISNodeType = nodeMapEntry.node;
                if (vRMLDISNodeType.getRole() != 0) {
                    return;
                }
                long l = System.currentTimeMillis();
                long l2 = protocolDataUnit.getTimestampValue();
                if (vRMLDISNodeType != null) {
                    if (nodeMapEntry.listEntry != null) {
                        LiveListEntry liveListEntry = (LiveListEntry)nodeMapEntry.listEntry;
                        if (l2 > liveListEntry.espduTimestamp) {
                            liveListEntry.avgTime += (float)(l - liveListEntry.lastTime) / 5.0f;
                            liveListEntry.lastTime = l;
                            if (liveListEntry.currEspdu != null) {
                                liveListEntry.lastEspdu = liveListEntry.currEspdu;
                            }
                            liveListEntry.currFire = firePdu;
                            liveListEntry.newPackets = true;
                            break;
                        }
                        System.out.println("Tossing packet: " + l2 + " last: " + liveListEntry.espduTimestamp);
                        break;
                    }
                    LiveListEntry liveListEntry = new LiveListEntry(vRMLDISNodeType, System.currentTimeMillis());
                    nodeMapEntry.listEntry = liveListEntry;
                    liveListEntry.lastEspdu = null;
                    liveListEntry.currEspdu = null;
                    liveListEntry.currDetonate = null;
                    liveListEntry.currFire = firePdu;
                    liveListEntry.espduTimestamp = l2;
                    liveListEntry.closeEnough = false;
                    liveListEntry.avgTime = 0.01f;
                    liveListEntry.newPackets = true;
                    this.liveList.add(liveListEntry);
                    vRMLDISNodeType.setIsActive(true);
                    break;
                }
                System.out.println("Unknown entity: " + entityID);
                break;
            }
            case 3: 
            case 144: {
                DetonationPdu detonationPdu = (DetonationPdu)protocolDataUnit;
                EntityID entityID = detonationPdu.getTargetEntityID();
                this.disId.setValue(entityID.getSiteIDValue(), entityID.getApplicationIDValue(), entityID.getEntityIDValue());
                NodeMapEntry nodeMapEntry = (NodeMapEntry)this.nodeMap.get(this.disId);
                if (nodeMapEntry == null) {
                    return;
                }
                VRMLDISNodeType vRMLDISNodeType = nodeMapEntry.node;
                if (vRMLDISNodeType.getRole() != 0) {
                    return;
                }
                long l = System.currentTimeMillis();
                long l3 = protocolDataUnit.getTimestampValue();
                if (vRMLDISNodeType == null) break;
                if (nodeMapEntry.listEntry != null) {
                    LiveListEntry liveListEntry = (LiveListEntry)nodeMapEntry.listEntry;
                    if (l3 > liveListEntry.espduTimestamp) {
                        liveListEntry.avgTime += (float)(l - liveListEntry.lastTime) / 5.0f;
                        liveListEntry.lastTime = l;
                        if (liveListEntry.currEspdu != null) {
                            liveListEntry.lastEspdu = liveListEntry.currEspdu;
                        }
                        liveListEntry.currDetonate = detonationPdu;
                        liveListEntry.closeEnough = false;
                        liveListEntry.newPackets = true;
                        break;
                    }
                    System.out.println("Tossing packet: " + l3 + " last: " + liveListEntry.espduTimestamp);
                    break;
                }
                LiveListEntry liveListEntry = new LiveListEntry(vRMLDISNodeType, System.currentTimeMillis());
                nodeMapEntry.listEntry = liveListEntry;
                liveListEntry.lastEspdu = null;
                liveListEntry.currEspdu = null;
                liveListEntry.currDetonate = detonationPdu;
                liveListEntry.espduTimestamp = l3;
                liveListEntry.closeEnough = false;
                liveListEntry.avgTime = 0.01f;
                liveListEntry.newPackets = true;
                this.liveList.add(liveListEntry);
                vRMLDISNodeType.setIsActive(true);
                break;
            }
            case 1: {
                EntityStatePdu entityStatePdu = (EntityStatePdu)protocolDataUnit;
                EntityID entityID = entityStatePdu.getEntityID();
                this.disId.setValue(entityID.getSiteIDValue(), entityID.getApplicationIDValue(), entityID.getEntityIDValue());
                NodeMapEntry nodeMapEntry = (NodeMapEntry)this.nodeMap.get(this.disId);
                if (nodeMapEntry == null) {
                    int n2 = this.managerList.size();
                    for (int i = 0; i < n2; ++i) {
                        VRMLDISManagerNodeType vRMLDISManagerNodeType = (VRMLDISManagerNodeType)this.managerList.get(i);
                        if (this.notifiedSet.contains(this.disId)) continue;
                        vRMLDISManagerNodeType.entityArrived(entityStatePdu);
                        this.notifiedSet.add(this.disId.clone());
                    }
                    return;
                }
                VRMLDISNodeType vRMLDISNodeType = nodeMapEntry.node;
                if (vRMLDISNodeType.getRole() != 0) {
                    System.out.println("Ignoring ESPDU");
                    return;
                }
                long l = System.currentTimeMillis();
                long l4 = protocolDataUnit.getTimestampValue();
                if (vRMLDISNodeType == null) break;
                if (nodeMapEntry.listEntry != null) {
                    LiveListEntry liveListEntry = (LiveListEntry)nodeMapEntry.listEntry;
                    if (l4 > liveListEntry.espduTimestamp) {
                        liveListEntry.avgTime += (float)(l - liveListEntry.lastTime) / 5.0f;
                        liveListEntry.lastTime = l;
                        liveListEntry.lastEspdu = liveListEntry.currEspdu;
                        liveListEntry.currEspdu = entityStatePdu;
                        liveListEntry.closeEnough = false;
                        liveListEntry.newPackets = true;
                        break;
                    }
                    System.out.println("Tossing packet: " + l4 + " last: " + liveListEntry.espduTimestamp);
                    break;
                }
                LiveListEntry liveListEntry = new LiveListEntry(vRMLDISNodeType, System.currentTimeMillis());
                nodeMapEntry.listEntry = liveListEntry;
                liveListEntry.lastEspdu = entityStatePdu;
                liveListEntry.currEspdu = entityStatePdu;
                liveListEntry.rotationConverger = new OrderNQuat4dConverger(2, 200, null);
                liveListEntry.translationConverger = new OrderNVector3dConverger(2, 200, null);
                liveListEntry.espduTimestamp = l4;
                liveListEntry.closeEnough = false;
                liveListEntry.avgTime = 0.01f;
                liveListEntry.newPackets = true;
                this.liveList.add(liveListEntry);
                vRMLDISNodeType.setIsActive(true);
                break;
            }
            default: {
                System.out.println("Unhandled DIS node:  type: " + n + " DET: " + 3);
            }
        }
    }

    public void receivePdu(ProtocolDataUnit protocolDataUnit, BehaviorProducerIF behaviorProducerIF, Object object) {
        System.out.println("Got pdu from producer2");
    }
}

