target=basicC basicL parallelrc parallelrl serialrc serialcr serialrl seriallr

#include "xiao.inc"
\text{A=}

#if #TARGET (basicC)
  \title{1 - condensateur}
  \text{ctype=5/closeser}
  \text{comp=acsrc @S,wire,iArrow @@I,,cap _CL_}
  \text{lctype=c}
  \text{f_a1=v1/imped}
  \text{f_v2=v1}
  \text{f_a2=a1}
  \text{f_ph1=90}
  \text{f_ph2=0}
  \text{noask=R}
#endif
  
#if #TARGET (basicL)
  \title{1 - solnoide}
  \text{ctype=5/closeser}
  \text{comp=acsrc @S,wire,iArrow @@I,,coilR _CL_}
  \text{lctype=l}
  \text{f_a1=v1/imped}
  \text{f_v2=v1}
  \text{f_a2=a1}
  \text{f_ph1=90}
  \text{f_ph2=0}
  \text{noask=R}
#endif
  
#if #TARGET (parallelrc)
  \title{2 - parallle RC}
  \text{ctype=5/closeparr}
  \text{lctype=c}
  \text{comp=acsrc @S,iArrow @@I,res _R_,,cap _CL_}
  \text{f_a1=v1*sqrt(1/imped^2+1/r^2)}
  \text{f_v2=v1}
  \text{f_a2=v1/imped}
  \text{f_ph1=atan(r/imped)*180/pi}
  \text{f_ph2=0}
  \text{noask=}
#endif
  
#if #TARGET (parallelrl)
  \title{2 - parallle RL}
  \text{ctype=5/closeparr}
  \text{lctype=l}
  \text{comp=acsrc @S,iArrow @@I,res _R_,,coilR _CL_}
  \text{f_a1=v1*sqrt(1/imped^2+1/r^2)}
  \text{f_v2=v1}
  \text{f_a2=v1/imped}
  \text{f_ph1=atan(r/imped)*180/pi}
  \text{f_ph2=0}
  \text{noask=}
#endif
  
#if #TARGET (serialrc)
  \title{2 - srie RC}
  \text{ctype=7/closeser}
  \text{lctype=c}
  \text{comp=wire,acsrc @S,wire,iArrow @@I,chas,res _R_,cap _CL_}
  \text{A=12,5.5}
  \text{f_a1=v1/sqrt(imped^2+r^2)}
  \text{f_v2=v1*imped/sqrt(imped^2+r^2)}
  \text{f_a2=a1}
  \text{f_ph1=atan(imped/r)*180/pi}
  \text{f_ph2=0}
  \text{noask=}
#endif
  
#if #TARGET (serialcr)
  \title{2 - srie CR}
  \text{ctype=7/closeser}
  \text{lctype=c}
  \text{comp=wire,acsrc @S,wire,iArrow @@I,chas,cap _CL_,res _R_}
  \text{A=12,5.5}
  \text{f_a1=v1/sqrt(imped^2+r^2)}
  \text{f_v2=v1*r/sqrt(imped^2+r^2)}
  \text{f_a2=a1}
  \text{f_ph1=atan(imped/r)*180/pi}
  \text{f_ph2=0}
  \text{noask=}
#endif
  
#if #TARGET (serialrl)
  \title{2 - srie RL}
  \text{ctype=7/closeser}
  \text{lctype=l}
  \text{comp=wire,acsrc @S,wire,iArrow @@I,chas,res _R_,coilR _CL_}
  \text{A=12,5.5}
  \text{f_a1=v1/sqrt(imped^2+r^2)}
  \text{f_v2=v1*imped/sqrt(imped^2+r^2)}
  \text{f_a2=a1}
  \text{f_ph1=atan(imped/r)*180/pi}
  \text{f_ph2=0}
  \text{noask=}
#endif
  
#if #TARGET (seriallr)
  \title{2 - srie LR}
  \text{ctype=7/closeser}
  \text{lctype=l}
  \text{comp=wire,acsrc @S,wire,iArrow @@I,chas,coil _CL_,res _R_}
  \text{A=12,5.5}
  \text{f_a1=v1/sqrt(imped^2+r^2)}
  \text{f_v2=v1*r/sqrt(imped^2+r^2)}
  \text{f_a2=a1}
  \text{f_ph1=atan(imped/r)*180/pi}
  \text{f_ph2=0}
  \text{noask=}
#endif
  
#include "data.inc"
#include "confparm.inc"
#include "process.inc"

\text{vide=}

\text{pre=Dans le schma ci-contre, la source S est une tension alternative sinusoidale}
\text{pre=f iswordof \given?\pre \freq}
\text{pre=v1 iswordof \given?\pre de \v1 volts RMS}

\text{known=a1 iswordof \given?l'intensit du courant I = \a1 \Aunit:}
\text{known=a2 iswordof \given?wims(append item \vide l'intensit du courant
passant par R est \a2 \Aunit to \known)}
\text{known=v2 iswordof \given?wims(append item \vide la tension sur le point A
est de \v2 V to \known)}
\if{ph1 iswordof \given}{
 \if{ph1>0}{
  \text{add=la phase du courant I est en avance de \ph1&deg; par rapport 
la tension}
 }{
  \real{ph=-(\ph1)}
  \text{add=la phase du courant I est en retard de \ph&deg; par rapport 
la tension}
 }
 \text{known=wims(append item \vide \add to \known)}
}

\statement{
    <img align=right hspace=10 src=\circ> <p>
\if{\known notsametext }{
 \pre, \known.
}{
 \pre.
}
<p>Quelle est \quest&nbsp;? 
\embed{r1,8}\qunit
<p>
ATTENTION. Vous avez droit  une marge d&#39;erreur de \tolerance%
dans la rponse.

<br clear=right>
}

\answer{\quest}{\good}{type=range}

\feedback{(\reply1 > \good2 and \reply1<=\good4) or
(\reply1 < \good1 and \reply1 >= \good3)}{Attention  la tolrance d'erreur !
Votre calcul semble avoir une marge d'erreur trop importante.}

